/*
 * @(#)ZipMenuEdit.java	1.0 98/12/11
 *
 * Java Project performed by
 *     Frank Moisant
 *    Patrick Titiano
 *        (ITRA3)
 *
 */


import com.sun.java.swing.JMenu;
import com.sun.java.swing.JMenuItem;
import com.sun.java.swing.ImageIcon;
import com.sun.java.swing.AbstractButton;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

import java.io.File;


/**
 * Class use to create the edit menu
 * @see AllActionListener
 * @version 1.0
 * @author Frank Moisant - Patrick Titiano
 */
public class ZipMenuEdit extends JMenu {
   
    /**
     * Constructor of the class
     * @param allActionListener the global listener
     */ 
    public ZipMenuEdit(AllActionListener allActionListener) {
	super("Edit");

	// create the menu items
	JMenuItem selectAllItem = new JMenuItem("Select all");
	JMenuItem selectNoneItem = new JMenuItem("Select none");

	// setup the menu items
	selectAllItem.setHorizontalTextPosition(AbstractButton.RIGHT);
	selectNoneItem.setHorizontalTextPosition(AbstractButton.RIGHT);
	selectAllItem.setActionCommand("SelectAll");
	selectNoneItem.setActionCommand("SelectNone");
	selectAllItem.addActionListener(allActionListener);
	selectNoneItem.addActionListener(allActionListener);

	// add the menu items 
	add(selectAllItem);
	add(selectNoneItem);
    }
}
